#ifndef GANAH_ENGINE_H
#define GANAH_ENGINE_H

#include "allegro.h"
#include "SGentite.h"
#include "SGaffichage.h"
#include "SGevent.h"
#include "SGfichier.h"
#include "SGtimer.h"
#include "SGphysique.h"
#include "SGReseau.h"
#include "keyevent.h"
#include "classicevent.h"
#include "keyrxevent.h"
#include "rxevent.h"

// Ensemble de fonctions et procdures dfinissant les principales tapes du jeu
bool initialiserJeu();
void debutJeu();
void finJeu();
void afficherJeu();
void detruireJeu();
void restartJeu();
void finRound();

typedef enum ModeJeu { SOLO , MULTI };

class GanahEngine
{
    private:
        // Frequence du moteur : variable qui indique combien de fois le moteur fait de boucles en
        // une seconde
        int m_iFrequence;
        // Variable indiquant si le moteur est en pause ou non
        bool m_bPause;
        // Variable qui permet de quitter le jeu
        bool m_bQuitter;
        // Nom de la fentre
        char * m_szTitre;
        // Ensemble des pointeurs des diffrentes parties du moteur
        SGAffichage *m_pSGAffichage;
        SGFichier *m_pSGFichier;
        SGEntite *m_pSGEntite;
        SGEvent *m_pSGEvent;
        SGTimer *m_pSGTimer;
        SGPhysique *m_pSGPhysique;
        SGReseau *m_pSGReseau;
        // Pointeur statique permettant d'utiliser la classe en tant que singleton
        static GanahEngine * m_pGanahEngine;
        // Variable s'incrmentant toutes les millisecondes
        volatile int m_viTimer;
        // Mode de jeu
        static ModeJeu m_ModeJeu;
    public:
        int m_iCptEffectif; 
        // Constructeur permetant de crer une instance du moteur
        // szTitre correspond au nom de la fentre
        // iLargeur et iHauteur correspondent  la rsolution en X et Y du jeu
        // cCouleur correspond au nombre de bits par pixel
        // iFrequence est la frquence  laquelle tourne le moteur
        // mode indique si le jeu tourne en mode fentr ou plein cran
        // type dfinie comment le jeu est affich : en double ou triple buffering ou en Pageflipping
        GanahEngine(char *szTitre,const short int iLargeur,const short int iHauteur,
                const char cCouleur,const int iFrequence,ModeAffichage mode,TypeAffichage type);
        // Le destructeur s'occupe de dtruire toutes les instances des diffrentes parties du moteur
        // C'est  dire qu'il dtruit la partie affichage, fichier, evenement, timer et le moteur 
        // physique
        ~GanahEngine();
        // Fonction permettant d'obtenir le titre de la fentre
        char * GetTitre() const { return m_szTitre ; }
        // Procdure permettant de dfinir le titre de la fentre
        void SetTitre(char * szTitre) { m_szTitre=szTitre ; }
        // Fonction permettant d'obtenir le pointeur statique de la classe
        static GanahEngine *getEngine() { return m_pGanahEngine ; }
        // Fonction retournant la variable m_bQuitter
        bool getQuitter() { return m_bQuitter ; }
        // Fonction retournant la frquence du moteur
        int getFrequence() { return m_iFrequence ; }
        // Procdure permettant de quitter le jeu
        void quitter() { m_bQuitter=true ; }
        // Fonction permettant de savoir si le jeu est en pause ou non
        bool getPause() { return m_bPause ; }
        // Procdure qui met en pause le jeu
        void pauseOn() { m_bPause=true ; }
        // Procdure qui enleve la pause
        void pauseOff() { m_bPause=false ; }
        // Fonction retournant la variable m_viTimer
        volatile int getTimer() { return m_viTimer ; }
        // Fonction qui est charg d'initialiser la bibliothque Allegro, de dfinir le nom
        // de la fentre du jeu, d'appeler l'initialisation de l'affichage et d'installer
        // un timer sur la fonction runtimer
        // Retourne true si l'initialisation est correctement xecute et false dans le cas
        // contraire
        bool initialiser();
        // Procdure incrmentant la variable m_viTimer
        static void runTimer();
        
        static void setModeJeu(ModeJeu mode) { m_ModeJeu=mode ; }
        static ModeJeu getModeJeu() { return m_ModeJeu ; }
};

#endif
